/*:
 * @plugindesc メニューを右クリックまたはESCキーで閉じることができるプラグイン
 * @nikutomochi
 *
 * @help
 * このプラグインを導入すると、メニューを開いている状態で
 * 右クリックまたはESCキーを押すことでメニューを閉じることができます。
 */

(function() {
    'use strict';

    const _Scene_Menu_update = Scene_Menu.prototype.update;
    Scene_Menu.prototype.update = function() {
        _Scene_Menu_update.call(this);
        if (this._menuCalling && Input.isTriggered('escape')) {
            this._menuCalling = false;
            SoundManager.playCancel();
            SceneManager.pop();
        }
    };

    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function() {
        _Scene_Menu_createCommandWindow.call(this);
        this._commandWindow.setHandler('cancel', this.popScene.bind(this));
    };
})();